//*************************************************************************************************
//
//	Description:
//		Bink video shader
//		
//		
//
//	<P> Copyright (c) 2007 Blimey! Games Ltd. All rights reserved.
//
//	Author: 
//		Tim Mann
//
//	History:
//
//	<TABLE>
//		\Author         Date        Version       Description
//		--------        -----       --------      ------------
//		TMann			 08/15/2008	 1.0			Created
//
//	<TABLE>
//
//*************************************************************************************************

float4 Adjust;
float Alpha;

//-----------------------------------------------------------------------
//
// Samplers
//

sampler2D Yplane : SAMPLER < bool appEdit = false; > = sampler_state
{
	MinFilter = LinearMipMapLinear;
	MagFilter = Linear;
	MipFilter = Linear;
	AddressU  = ClampToEdge;
	AddressV  = ClampToEdge;
	PS3MaxAnisotropy = Aniso1;
};

sampler2D cRplane : SAMPLER < bool appEdit = false; > = sampler_state
{
	MinFilter = LinearMipMapLinear;
	MagFilter = Linear;
	MipFilter = Linear;
	AddressU  = ClampToEdge;
	AddressV  = ClampToEdge;
	PS3MaxAnisotropy = Aniso1;
};

sampler2D cBplane : SAMPLER < bool appEdit = false; > = sampler_state
{
	MinFilter = LinearMipMapLinear;
	MagFilter = Linear;
	MipFilter = Linear;
	AddressU  = ClampToEdge;
	AddressV  = ClampToEdge;
	PS3MaxAnisotropy = Aniso1;
};

sampler2D Aplane : SAMPLER < bool appEdit = false; > = sampler_state
{
	MinFilter = LinearMipMapLinear;
	MagFilter = Linear;
	MipFilter = Linear;
	AddressU  = ClampToEdge;
	AddressV  = ClampToEdge;
	PS3MaxAnisotropy = Aniso1;
};

//-----------------------------------------------------------------------
//
// Vertex Shader(s)
//

struct VSINPUT
{
	float3 position : POSITION;
	float2 texCoord : TEXCOORD0;
};

struct VSOUTPUT
{
	float4 position		: POSITION;												
	float2 texCoord		: TEXCOORD0;											
};

//-----------------------------------------------------------------------
//
// Vertex shader code
//

VSOUTPUT VShader( VSINPUT _input )
{
	VSOUTPUT _output;
	
	_output.texCoord=_input.texCoord;
	_output.position.x=_input.position.x*Adjust.z;
	_output.position.y=_input.position.y*Adjust.w;
	_output.position.x+=Adjust.x;
	_output.position.y+=Adjust.y;
	_output.position.z=0.5f;
	_output.position.w=1.0f;
	
	return _output;
}

//-----------------------------------------------------------------------
//
// Fragment Shader(s)
//

struct PSINPUT
{
	float2 texCoord					: TEXCOORD0;												
	
};

struct PSOUTPUT
{
	float4 colour : COLOR0;
};



//-----------------------------------------------------------------------
//
// Fragment shader code
//

PSOUTPUT fragmentShaderStrYCrCbToRGBNoPixelAlpha( PSINPUT _input )
{
	float4 c;
	float4 p;
	const float4  tor = float4( 1.164123535f, 1.595794678f, 0.0f, -0.87065506f );
	const float4  tog = float4( 1.164123535f, -0.813476563f, -0.391448975f, 0.529705048f );
	const float4  tob = float4( 1.164123535f,  0.0f, 2.017822266f, -1.081668854f );

	c.x = tex2D( Yplane, _input.texCoord ).x;
	c.y = tex2D( cRplane, _input.texCoord ).x;
	c.z = tex2D( cBplane, _input.texCoord ).x;
	c.w = 1.0f;
	p.x = dot( tor, c );
	p.y = dot( tog, c );
	p.z = dot( tob, c );
	p.w = Alpha;
	
	PSOUTPUT _output;
	_output.colour=p;
	return _output;
}

//
// simple pixel shader to apply the yuvtorgb matrix with alpha
//

PSOUTPUT fragmentShaderStrYCrCbAToRGBA( PSINPUT _input )
{
	float4 c;
	float4 p;
	const float4  tor = float4( 1.164123535f, 1.595794678f, 0.0f, -0.87065506f );
	const float4  tog = float4( 1.164123535f, -0.813476563f, -0.391448975f, 0.529705048f );
	const float4  tob = float4( 1.164123535f,  0.0f, 2.017822266f, -1.081668854f );
	
	c.x = tex2D( Yplane, _input.texCoord ).x;
	c.y = tex2D( cRplane, _input.texCoord ).x;
	c.z = tex2D( cBplane, _input.texCoord ).x;
	c.w = 1.0f;
	p.w = tex2D( Aplane, _input.texCoord ).x;
	p.x = dot( tor, c );
	p.y = dot( tog, c );
	p.z = dot( tob, c );
	p.w *= Alpha;
	
	PSOUTPUT _output;
	_output.colour=p;
	return _output;
}

//-----------------------------------------------------------------------
//
// Technique(s)
//

technique StrYCrCbToRGBNoPixelAlpha
{
	pass Pass0
	{
		ZEnable=false;
		CullFaceEnable=false;
		AlphaTestEnable=false;
		VertexShader = compile sce_vp_rsx VShader();
		PixelShader = compile sce_fp_rsx fragmentShaderStrYCrCbToRGBNoPixelAlpha();
	}
}

technique StrYCrCbToRGBA
{
	pass Pass0
	{
		ZEnable=false;
		CullFaceEnable=false;
		AlphaTestEnable=false;
		VertexShader = compile sce_vp_rsx VShader();
		PixelShader = compile sce_fp_rsx fragmentShaderStrYCrCbAToRGBA();
	}
}
